CREATE OR REPLACE FUNCTION sp_RenameTreeNode (VARCHAR, VARCHAR)
RETURNS void AS $$
DECLARE
    pGuid ALIAS FOR $1;
    pNewDisplayName ALIAS FOR $2;
BEGIN

UPDATE tb_tree_node
SET display_name = pNewDisplayName
WHERE guid = pGuid
  AND pGuid IS NOT NULL
  AND pNewDisplayName IS NOT NULL
  AND pNewDisplayName <> ''
  AND pGuid NOT IN (SELECT tb_system_node.guid
                    FROM tb_system_node);
END

$$ LANGUAGE plpgsql;
